<?php 

/**
 *  banner widget
 * 
**/
 
add_action( 'widgets_init', 'wp_banner_widget' );

function wp_banner_widget() {
	register_widget( 'banner_widget' );
}

class banner_widget extends WP_Widget {

	public function __construct(){
		$widget_ops = array( 'classname' => 'banner_widget' );
		$control_ops = array( 'id_base' => 'banner_widget' );
		parent::__construct( 'banner_widget',''.__( 'News - بنر تبلیغاتی') , $widget_ops, $control_ops );
	}
	
	function widget( $args, $instance ) {
		extract( $args );

		$title = apply_filters('widget_title', empty($instance['title']) ? __('تبلیغات بنری') : $instance['title'], $instance, $this->id_base);
		$count = (int)$instance['count'];
		$output = '';
		if( $count > 0){
			for($i=1; $i<= $count; $i++){
				$image = isset($instance['ad_'.$i.'_image'])?$instance['ad_'.$i.'_image']:'';
				$link = isset($instance['ad_'.$i.'_link'])?$instance['ad_'.$i.'_link']:'';
				$output .= ' <div class="all_ads"><a href="'.$link.'" target="_blank" rel="nofollow"><img src="'.$image.'"></a></div>';
				}
		}
		
		
		if ( !empty( $output ) ) {
			echo $output;
		}
					
	}

	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['title'] = strip_tags( $new_instance['title'] );
		$instance['count'] = (int) $new_instance['count'];
		for($i=1;$i<=$instance['count'];$i++){
			$instance['ad_'.$i.'_image'] = strip_tags($new_instance['ad_'.$i.'_image']);
			$instance['ad_'.$i.'_link'] = strip_tags($new_instance['ad_'.$i.'_link']);
		}
		return $instance;
	}

	function form( $instance ) {
		$title = isset($instance['title']) ? esc_attr($instance['title']) : '';
		$count = isset($instance['count']) ? absint($instance['count']) : 1;
		for($i=1;$i<=10;$i++){
			$ad_image = 'ad_'.$i.'_image';
			$$ad_image = isset($instance[$ad_image]) ? $instance[$ad_image] : '';
			$ad_link = 'ad_'.$i.'_link';
			$$ad_link = isset($instance[$ad_link]) ? $instance[$ad_link] : '';
		} 
    ?>
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'عنوان:') ?></label>
			<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php if( !empty($instance['title']) ) echo $instance['title']; ?>" class="widefat" type="text" />
		</p>
        <p><label for="<?php echo $this->get_field_id('count'); ?>"><?php _e('تعداد تبلیغات:'); ?></label>
		<input id="<?php echo $this->get_field_id('count'); ?>" class="advertisement_count" name="<?php echo $this->get_field_name('count'); ?>" type="text" value="<?php echo $count; ?>" size="3" /></p>
		<p>
			<em><?php _e("توجه:آدرس را کامل وارد کنید <br/>به طور مثال<code>http://www.yoursite.ir</code>");?></em>
		</p>
        <div class="sponsor">
		<?php for($i=1;$i<=10;$i++): $ad_image = 'ad_'.$i.'_image'; $ad_link = 'ad_'.$i.'_link'; ?>
			<div class="advertisement_<?php echo $i;?>" <?php if($i>$count):?>style="display:none"<?php endif;?>>
             
				<p><label for="<?php echo $this->get_field_id( $ad_image ); ?>"><?php printf(__('آدرس تصویر %s :'),$i);?></label>
				<input class="widefat" id="<?php echo $this->get_field_id( $ad_image ); ?>" name="<?php echo $this->get_field_name( $ad_image ); ?>" type="text" value="<?php echo $$ad_image; ?>" /></p>
				<p><label for="<?php echo $this->get_field_id( $ad_link ); ?>"><?php printf(__('لینک %s :'),$i);?></label>
				<input class="widefat" id="<?php echo $this->get_field_id( $ad_link ); ?>" name="<?php echo $this->get_field_name( $ad_link ); ?>" type="text" value="<?php echo $$ad_link; ?>" /></p>
			</div>
		<?php endfor;?>
		</div>
	

	<?php
	}
}
?>