<?php
add_action( 'widgets_init', 'wp_posts_box_1_widget' );
function wp_posts_box_1_widget() {
	register_widget( 'wp_posts_box_1' );
}

class wp_posts_box_1 extends WP_Widget {

	public function __construct(){
		$widget_ops = array( 'classname' => 'posts-box_1','description' => ' سایدبار اصلی'  );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'posts-box-1-widget' );
		parent::__construct( 'posts-box-1-widget',''. __( 'News - اسلایدر اصلی ' , 'wp'), $widget_ops, $control_ops );
	}
	
	function widget( $args, $instance ) {
		extract( $args );
		
        if ( isset( $instance[ 'category_link' ] ) ) {
			$category_link = $instance[ 'category_link' ];
		}

        if ( isset( $instance[ 'category_target' ] ) ) {
			$category_target = $instance[ 'category_target' ];
		}

		$title     = $title = apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base );
		$category  = $instance['category'];
		$number    = $instance['number'];
		$icon_code = apply_filters( 'icon_code', $instance['icon_code'] );
?>
<div class="flexslider" id="<?php echo $args['widget_id']; ?>">
		<ul class="slides">
          <?php
    $my_query = new WP_Query('showposts='.$number.'&cat='.$category);
    while ($my_query->have_posts()):  $my_query->the_post(); ?>
	<li>
	 <section class="box-content">
      <div class="box-content-right">   
				   <?php if(has_post_thumbnail()){?><a href="<?php the_permalink(); ?>"><?php $ata = get_the_title(); if ( has_post_thumbnail()) the_post_thumbnail('img-410', array('title' => esc_attr( $post->post_title ) , 'alt' => $ata ) ); ?></a><?php }else{ ?><img src="<?php bloginfo("template_url"); ?>/img/none.png"><?php } ?>
				   <span class="boxe-m-date"><?php the_time('d M Y'); ?></span>
				   </div>
				<div class="box-content-left">
			 <h3 class="post-title2">
			 <?php if(get_post_meta( get_the_ID(), 'meta-text-1', true )!=null){ ?> <small class="subtitle text-muted"><i class="fa fa-stop" aria-hidden="true"></i> <?php echo get_post_meta( get_the_ID(), 'meta-text-1', true ); ?></small> <?php } ?>
             <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
                </h3>
				 <div class="post-excerpt2"><p><?php if(get_meta('lead') != false) : echo get_meta('lead'); else : the_excerpt(); endif; ?></p></div>	
            </div>	
      </section></li>
          <?php endwhile; ?>
          <?php wp_reset_query(); ?>
		</ul>
	</div>	
	<script>
	jQuery(document).ready(function() {
	  jQuery('#<?php echo $args['widget_id']; ?>').flexslider({
		animation: "fade",
		slideshowSpeed: 7000,
		animationSpeed: 600,
		randomize: false,
		pauseOnHover: true,
		prevText: "",
		nextText: "",
		controlNav: false
	  });
	});
	</script>		  	  
 <div class="separator"></div> 
       	<?php 
	}

	function update( $new_instance, $old_instance ) {
		$instance              = $old_instance;
		$instance['title']     = wp_strip_all_tags( $new_instance['title'] );
		$instance['category']  = wp_strip_all_tags( $new_instance['category'] );
		$instance['category_link']     = wp_strip_all_tags( $new_instance['category_link'] );
		$instance['category_target']  = wp_strip_all_tags( $new_instance['category_target'] );
		$instance['number']    = is_numeric( $new_instance['number'] ) ? intval( $new_instance['number'] ) : 5;
        $instance['icon_code'] = ( ! empty( $new_instance['icon_code'] ) ) ? $new_instance['icon_code'] : '';
		return $instance;
	}

	function form( $instance ) {
		$defaults  = array( 'title' => '', 'category' => '', 'number' => 3, 'show_date' => '' );
		$instance  = wp_parse_args( ( array ) $instance, $defaults );
		$title     = $instance['title'];
		$category  = $instance['category'];
		$category_link     = $instance['category_link'];
		$category_target  = $instance['category_target'];	
		$number    = $instance['number'];
		if ( isset( $instance[ 'icon_code' ] ) ) {
		$icon_code = $instance[ 'icon_code' ];
		}
		?>
		<p>
			<?php $icon_url = esc_url( get_template_directory_uri().( '/img/box/1.png' ) ); ?>
			<center><img src="<?php echo $icon_url; ?>" alt="" /></center>
		</p>
		<p><em style="color:#0073aa;"><?php echo 'توجه : '; ?></em></p>
		<p><em style="color:#0085ba;"><?php echo 'از این ابزارک بی نهایت باکس بسازید.'; ?></em></p>
		<p><em style="color:#0085ba;"><?php echo 'یک مطلب برای این باکس انتخاب و در ابتدا قرار دهید.'; ?></em></p>
		<p>
			<label for="<?php echo $this->get_field_id( 'category' ); ?>"><?php _e( 'انتخاب دسته' ); ?>:</label>				
			
			<?php

			wp_dropdown_categories( array(

				'orderby'    => 'title',
				'hide_empty' => false,
				'name'       => $this->get_field_name( 'category' ),
				'id'         => $this->get_field_id( 'category' ),
				'class'      => 'widefat',
				'selected'   => $category

			) );

			?>

		</p>
		<p>
		    <input type="checkbox" name="<?php echo $this->get_field_name( 'category_target' ); ?>" id="<?php echo $this->get_field_id( 'category_target' ); ?>" class="checkbox" <?php checked( $category_target, "on" ); ?>>
		    <label for="<?php echo $this->get_field_id( 'category_target' ); ?>">در زبانه جدید باز شود</label>
		</p>		
		<p>
			<label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'تعداد مطالب' ); ?>: </label>
			<input type="text" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" value="<?php echo esc_attr( $number ); ?>" size="3" />
		</p>

		
		
		<?php
	
	}
}
?>