<?php
add_action( 'widgets_init', 'wp_posts_box_2_widget' );
function wp_posts_box_2_widget() {
	register_widget( 'wp_posts_box_2' );
}

class wp_posts_box_2 extends WP_Widget {

	public function __construct(){
		$widget_ops = array( 'classname' => 'posts-box_2','description' => ' سایدبار اصلی'  );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'posts-box-2-widget' );
		parent::__construct( 'posts-box-2-widget',''. __( 'News - باکس خبر اول و چهار خبر ' , 'wp'), $widget_ops, $control_ops );
	}
	
	function widget( $args, $instance ) {
		extract( $args );

        if ( isset( $instance[ 'category_link' ] ) ) {
			$category_link = $instance[ 'category_link' ];
		}

        if ( isset( $instance[ 'category_target' ] ) ) {
			$category_target = $instance[ 'category_target' ];
		}
		
		$title     = $title = apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base );
		$category  = $instance['category'];
		
		$icon_code = apply_filters( 'icon_code', $instance['icon_code'] );

		
 ?>
 <section class="posts">
   <div class="lead-posts">
         <div class="box-header"><b><?php echo $icon_code; ?> <?php echo $title; ?></b><span><a href="<?php echo $category_link; ?>"<?php if($category_target == "on") echo " target=\"_blank\""; ?>>آرشیو</a></span></div>			
        <div class="boxe-1-right">
        <?php
    $my_query = new WP_Query('showposts=1&cat='.$category);
    while ($my_query->have_posts()):  $my_query->the_post(); ?>
	<div class="lead-post-excerptb">
	<?php if(has_post_thumbnail()){?><a class="lead-post-excerpt-thumbb" href="<?php the_permalink(); ?>"><?php $ata = get_the_title(); if ( has_post_thumbnail()) the_post_thumbnail('img-293', array('title' => esc_attr( $post->post_title ) , 'alt' => $ata ) ); ?></a><?php }else{ ?><img src="<?php bloginfo("template_url"); ?>/img/none.png"><?php } ?>
	<span class="boxe-1-left-date"><?php the_time('d M Y'); ?></span>
	<h3 class="post-title">
	<?php if(get_post_meta( get_the_ID(), 'meta-text-1', true )!=null){ ?> <small class="subtitle text-muted"><i class="fa fa-stop" aria-hidden="true"></i> <?php echo get_post_meta( get_the_ID(), 'meta-text-1', true ); ?></small> <?php } ?>
    <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
    </h3>
	<div class="lead-post-excerpt-intro"> <p><?php if(get_meta('lead') != false) : echo get_meta('lead'); else : the_excerpt(); endif; ?></p></div>
            </div><!--/.lead-post-excerpt-->
        <?php endwhile; ?>
        <?php wp_reset_query(); ?>
        </div>
         <div class="boxe-1-left">
          <?php
    $my_query = new WP_Query('showposts=4&cat='.$category.'&offset=1');
    while ($my_query->have_posts()):  $my_query->the_post(); ?>
    <div class="last-post">
        <div class="column-post-item clearfix">
            <div class="column-post-thumb">
			 <?php if(has_post_thumbnail()){?><a class="attachment-small size-small wp-post-image" href="<?php the_permalink(); ?>"><?php $ata = get_the_title(); if ( has_post_thumbnail()) the_post_thumbnail('img-145', array('title' => esc_attr( $post->post_title ) , 'alt' => $ata ) ); ?></a><?php }else{ ?><img src="<?php bloginfo("template_url"); ?>/img/none.png"><?php } ?></a>
            </div>
            <h3 class="post-title2"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a><br><small class="subtitle text-muted"><?php the_time('d M Y'); ?></small></h3>
        </div>
     </div>
        <?php endwhile; ?>
        <?php wp_reset_query(); ?>
       </div> </div>
	   </section>
<div class="separator"></div>	

	<?php 
	}

	function update( $new_instance, $old_instance ) {
		$instance              = $old_instance;
		$instance['title']     = wp_strip_all_tags( $new_instance['title'] );
		$instance['category']  = wp_strip_all_tags( $new_instance['category'] );
		$instance['category_link']     = wp_strip_all_tags( $new_instance['category_link'] );
		$instance['category_target']  = wp_strip_all_tags( $new_instance['category_target'] );
		$instance['icon_code'] = ( ! empty( $new_instance['icon_code'] ) ) ? $new_instance['icon_code'] : '';
		return $instance;
	}

	function form( $instance ) {
		$defaults  = array( 'title' => '', 'category' => '', 'number' => 5, 'show_date' => '' );
		$instance  = wp_parse_args( ( array ) $instance, $defaults );
		$title     = $instance['title'];
		$category  = $instance['category'];
		$category_link     = $instance['category_link'];
		$category_target  = $instance['category_target'];
		if ( isset( $instance[ 'icon_code' ] ) ) {
		$icon_code = $instance[ 'icon_code' ];
		}
		?>
		
		<p>
			<?php $icon_url = esc_url( get_template_directory_uri().( '/img/box/2.png' ) ); ?>
			<center><img src="<?php echo $icon_url; ?>" alt="" /></center>
		</p>
        <p><em style="color:#0073aa;"><?php echo 'توجه : '; ?></em></p>
		<p><em style="color:#0085ba;"><?php echo 'از این ابزارک بی نهایت باکس بسازید.'; ?></em></p>
 		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'عنوان' ); ?>:</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		
		<p>
			<p>کد آیکن مورد نظر را برای این ابزارک از این  <a target="_blank" href="http://fontawesome.io/icons"><em style="color:#0073aa;"> لینک </em></a>دریافت و در کادر زیر قرار دهید</p>
			<textarea name="<?php echo $this->get_field_name( 'icon_code' ); ?>" placeholder="کد HTML" id="<?php echo $this->get_field_id( 'icon_code' ); ?>" class="widefat" style="direction:ltr;height:50px;"><?php echo esc_attr( $icon_code ); ?></textarea>
		</p>
		
		
		<p>
			<label for="<?php echo $this->get_field_id( 'category' ); ?>"><?php _e( 'انتخاب دسته' ); ?>:</label>				
			
			<?php

			wp_dropdown_categories( array(

				'orderby'    => 'title',
				'hide_empty' => false,
				'name'       => $this->get_field_name( 'category' ),
				'id'         => $this->get_field_id( 'category' ),
				'class'      => 'widefat',
				'selected'   => $category

			) );

			?>

		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'category_link' ); ?>">لینک آرشیو :</label>
			<input type="text" name="<?php echo $this->get_field_name( 'category_link' ); ?>" placeholder="http://...." value="<?php echo esc_attr( $category_link ); ?>" id="<?php echo $this->get_field_id( 'category_link' ); ?>" class="widefat" style="direction:ltr;">
		</p>
		<p>
		    <input type="checkbox" name="<?php echo $this->get_field_name( 'category_target' ); ?>" id="<?php echo $this->get_field_id( 'category_target' ); ?>" class="checkbox" <?php checked( $category_target, "on" ); ?>>
		    <label for="<?php echo $this->get_field_id( 'category_target' ); ?>">در زبانه جدید باز شود</label>
		</p>
	
		
		
		<?php
	
	}
}
?>