<?php
add_action( 'widgets_init', 'wp_posts_main_number_widget' );
function wp_posts_main_number_widget() {
	register_widget( 'wp_posts_main_number' );
}

class wp_posts_main_number extends WP_Widget {

	public function __construct(){
		$widget_ops = array( 'classname' => 'posts-main-number','description' => 'سایدبار اصلی'  );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'posts-main-number-widget' );
		parent::__construct( 'posts-main-number-widget',''. __( 'News - نوشته ها وبلاگی شماره صفحه' , 'wp'), $widget_ops, $control_ops );
	}

	
	function widget( $args, $instance ) {
		extract( $args );
		$title     = $title = apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base );
		$icon_code = apply_filters( 'icon_code', $instance['icon_code'] );
	
 ?>
<section class="posts">
 <div class="box-header"><b><?php echo $icon_code; ?> <?php echo $title; ?></b></div>			
 <?php if(have_posts()) : ?> <?php while(have_posts()) : the_post(); ?>
        <div class="post-item-excerpt clearfix">
        <div class="post-thumbnail medium">
              <?php if(has_post_thumbnail()){?> <a class="attachment-medium size-medium wp-post-image" href="<?php the_permalink(); ?>"><?php $ata = get_the_title(); if ( has_post_thumbnail()) the_post_thumbnail('img-145', array('title' => esc_attr( $post->post_title ) , 'alt' => $ata ) ); ?></a><?php }else{ ?><img src="<?php bloginfo("template_url"); ?>/img/none.png"><?php } ?>
	   <span class="boxe-1-left-date"><?php the_time('d M Y'); ?></span>
        </div>
        <div class="post-excerpt">
		  <?php if(get_post_meta( get_the_ID(), 'meta-text-1', true )!=null){ ?> <small class="subtitle text-muted"><i class="fa fa-stop" aria-hidden="true"></i> <?php echo get_post_meta( get_the_ID(), 'meta-text-1', true ); ?></small> <?php } ?>
                <h3 class="post-title2"> <a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
            <div class="post-excerpt-summary"><p><?php if(get_meta('lead') != false) : echo get_meta('lead'); else : the_excerpt(); endif; ?></p></div>
        </div>
    </div>		
   <?php endwhile;
				else:
				echo "<b>چیزی یافت نشد !</b>";
				 endif; ?>
      </section>

<?php if (function_exists("pagination")){ pagination($additional_loop->max_num_pages); } ?> 
 
	<?php 
	}

	function update( $new_instance, $old_instance ) {
		$instance              = $old_instance;
		$instance['title']     = wp_strip_all_tags( $new_instance['title'] );
        $instance['icon_code'] = ( ! empty( $new_instance['icon_code'] ) ) ? $new_instance['icon_code'] : '';
		return $instance;
	}

	function form( $instance ) {
		$instance  = wp_parse_args( ( array ) $instance, $defaults );
		$title     = $instance['title'];
		if ( isset( $instance[ 'icon_code' ] ) ) {
		$icon_code = $instance[ 'icon_code' ];
		}
		?>
		<p>
		<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'عنوان' ); ?>:</label>
		<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		<p>
		<p>کد آیکن مورد نظر را برای این ابزارک از این  <a target="_blank" href="http://fontawesome.io/icons"><em style="color:#0073aa;"> لینک </em></a>دریافت و در کادر زیر قرار دهید</p>
		<textarea name="<?php echo $this->get_field_name( 'icon_code' ); ?>" placeholder="کد HTML" id="<?php echo $this->get_field_id( 'icon_code' ); ?>" class="widefat" style="direction:ltr;height:50px;"><?php echo esc_attr( $icon_code ); ?></textarea>
		</p>
        <p><em style="color:#0073aa;"><?php echo 'توجه : '; ?></em></p>
		<p><em style="color:#0085ba;"><?php echo 'این ابزارک اخرین اخبار سایت را با شماره صفحه نمایش می دهد.'; ?></em></p>
		<p><em style="color:#0085ba;"><?php echo ' برای نمایش تعداد دلخواه به بخش تنظیمات وردپرس  » خواندن مراجعه و گزینه بیشترین تعداد نوشته‌ها در هر برگه‌ی وبلاگ را تنظیم کنید.'; ?></em></p>
	

		<?php
	
	}
}
?>