<?php

add_action( 'widgets_init', 'wp_main_post_widget' );
function wp_main_post_widget() {
	register_widget( 'wp_main_post' );
}

class wp_main_post extends WP_Widget {

	public function __construct(){
		$widget_ops = array( 'classname' => 'posts-main' ,'description' => 'سایدبار اصلی' );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'posts-main-widget' );
		parent::__construct( 'posts-main-widget',''. __( 'News - نوشته ها وبلاگی' , 'wp'), $widget_ops, $control_ops );
	}
	
	function widget( $args, $instance ) {
		extract( $args );
		
        if ( isset( $instance[ 'category_link' ] ) ) {
			$category_link = $instance[ 'category_link' ];
		}

        if ( isset( $instance[ 'category_target' ] ) ) {
			$category_target = $instance[ 'category_target' ];
		}

		$title     = $title = apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base );
		$category  = $instance['category'];
		$number    = $instance['number'];
		$icon_code = apply_filters( 'icon_code', $instance['icon_code'] );
?>

  <section class="posts">
    <div class="box-header"><b><?php echo $icon_code; ?> <?php echo $title; ?></b></div>			
          <?php
    $my_query = new WP_Query('showposts='.$number.'&cat='.$category);
    while ($my_query->have_posts()):  $my_query->the_post(); ?>
        <div class="post-item-excerpt clearfix">
        <div class="post-thumbnail medium">
			     <?php if(has_post_thumbnail()){?> <a class="attachment-medium size-medium wp-post-image" href="<?php the_permalink(); ?>"><?php $ata = get_the_title(); if ( has_post_thumbnail()) the_post_thumbnail('img-145', array('title' => esc_attr( $post->post_title ) , 'alt' => $ata ) ); ?></a><?php }else{ ?><img src="<?php bloginfo("template_url"); ?>/img/none.png"><?php } ?>
				<span class="boxe-1-left-date"><?php the_time('d M Y'); ?></span>
        </div>
        <div class="post-excerpt">
		  <?php if(get_post_meta( get_the_ID(), 'meta-text-1', true )!=null){ ?> <small class="subtitle text-muted"><i class="fa fa-stop" aria-hidden="true"></i> <?php echo get_post_meta( get_the_ID(), 'meta-text-1', true ); ?></small> <?php } ?>
                <h3 class="post-title2"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
            <div class="post-excerpt-summary">
                <p><?php if(get_meta('lead') != false) : echo get_meta('lead'); else : the_excerpt(); endif; ?></p>
            </div>
        </div>
    </div>
          <?php endwhile; ?>
          <?php wp_reset_query(); ?>
		 <div class="more-top-news"><a href="<?php echo $category_link; ?>"<?php if($category_target == "on") echo " target=\"_blank\""; ?>><h3> ادامه <?php echo $title; ?> .... </h3></a></div> 	  
      </section>

       	<?php 
	}

	function update( $new_instance, $old_instance ) {
		$instance              = $old_instance;
		$instance['title']     = wp_strip_all_tags( $new_instance['title'] );
		$instance['category']  = wp_strip_all_tags( $new_instance['category'] );
		$instance['category_link']     = wp_strip_all_tags( $new_instance['category_link'] );
		$instance['category_target']  = wp_strip_all_tags( $new_instance['category_target'] );
		$instance['number']    = is_numeric( $new_instance['number'] ) ? intval( $new_instance['number'] ) : 5;
        $instance['icon_code'] = ( ! empty( $new_instance['icon_code'] ) ) ? $new_instance['icon_code'] : '';
		return $instance;
	}

	function form( $instance ) {
		$defaults  = array( 'title' => '', 'category' => '', 'number' => 6, 'show_date' => '' );
		$instance  = wp_parse_args( ( array ) $instance, $defaults );
		$title     = $instance['title'];
		$category  = $instance['category'];
		$category_link     = $instance['category_link'];
		$category_target  = $instance['category_target'];	
		$number    = $instance['number'];
		if ( isset( $instance[ 'icon_code' ] ) ) {
		$icon_code = $instance[ 'icon_code' ];
		}
		?>
		<p>
			<?php $icon_url = esc_url( get_template_directory_uri().( '/img/box/mine.png' ) ); ?>
			<center><img src="<?php echo $icon_url; ?>" alt="" /></center>
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'عنوان' ); ?>:</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		
		<p>
			<p>کد آیکن مورد نظر را برای این ابزارک از این  <a target="_blank" href="http://fontawesome.io/icons"><em style="color:#0073aa;"> لینک </em></a>دریافت و در کادر زیر قرار دهید</p>
			<textarea name="<?php echo $this->get_field_name( 'icon_code' ); ?>" placeholder="کد HTML" id="<?php echo $this->get_field_id( 'icon_code' ); ?>" class="widefat" style="direction:ltr;height:50px;"><?php echo esc_attr( $icon_code ); ?></textarea>
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'category' ); ?>"><?php _e( 'انتخاب دسته' ); ?>:</label>				
			
			<?php

			wp_dropdown_categories( array(

				'orderby'    => 'title',
				'hide_empty' => false,
				'name'       => $this->get_field_name( 'category' ),
				'id'         => $this->get_field_id( 'category' ),
				'class'      => 'widefat',
				'selected'   => $category

			) );

			?>

		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'category_link' ); ?>">لینک آرشیو :</label>
			<input type="text" name="<?php echo $this->get_field_name( 'category_link' ); ?>" placeholder="http://...." value="<?php echo esc_attr( $category_link ); ?>" id="<?php echo $this->get_field_id( 'category_link' ); ?>" class="widefat" style="direction:ltr;">
		</p>
		<p>
		    <input type="checkbox" name="<?php echo $this->get_field_name( 'category_target' ); ?>" id="<?php echo $this->get_field_id( 'category_target' ); ?>" class="checkbox" <?php checked( $category_target, "on" ); ?>>
		    <label for="<?php echo $this->get_field_id( 'category_target' ); ?>">در زبانه جدید باز شود</label>
		</p>		
		<p>
			<label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'تعداد مطالب' ); ?>: </label>
			<input type="text" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" value="<?php echo esc_attr( $number ); ?>" size="3" />
		</p>

		
		
		<?php
	
	}
}
?>