<?php
## widget_tabs
add_action( 'widgets_init', 'widget_tabs_box' );
function widget_tabs_box(){
	register_widget( 'widget_tabs' );
}
class widget_tabs extends WP_Widget {
	public function __construct(){
		$widget_ops = array( 'description' => 'مطالب محبوب، جدید ، دیدگاهها'  );
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'widget_tabs' );
		parent::__construct( 'widget_tabs',''. __( 'News - تب مطالب' , 'wp'), $widget_ops, $control_ops );
	}
	function widget( $args, $instance ) {
		extract( $args );
		$posts_order = $instance['posts_order'];
		if( empty($instance['posts_number']) || $instance['posts_number'] == ' ' || !is_numeric($instance['posts_number']))	$posts_number = 5;
		else $posts_number = $instance['posts_number'];
	?>
	<div class="sidebar-box">
	<div class="widget" id="tabbed-widget">
		<div class="widget-container">
			<div class="widget-top">
				<div class="tabs posts-taps">
					<b class="tabs"><a href="#tab1"> محبوب </a></b>
					<b class="tabs"><a href="#tab2"> جدید </a></b>
					<b class="tabs" style="margin-left:0; "><a href="#tab3"> کامنت</a></b>
				</div>
			</div>
			<div id="tab1" class="tabs-wrap">
				<ul>
					<?php if( $posts_order == 'viewed' ) tie_most_viewed_posts( $posts_number  );
						else tie_popular_posts( $posts_number  );
					?>	
				</ul>
			</div>
			<div id="tab2" class="tabs-wrap">
				<ul>
					<?php tie_last_posts( $posts_number  )?>	
				</ul>
			</div>
			<div id="tab3" class="tabs-wrap">
				<ul>
					<?php tie_most_commented( $posts_number  );?>
				</ul>
			</div>
		</div>
	</div></div><!-- .widget /-->
<?php
	}
	
	function update( $new_instance, $old_instance ) {
		$instance = $old_instance;
		$instance['posts_order'] = strip_tags( $new_instance['posts_order'] );
		$instance['posts_number'] = strip_tags( $new_instance['posts_number'] );
		return $instance;
	}

	function form( $instance ) {
		$defaults = array( 'posts_order' => 'popular', 'posts_number' => 5 );
		$instance = wp_parse_args( (array) $instance, $defaults ); ?>

	<p>
			<label for="<?php echo $this->get_field_id( 'posts_number' ); ?>">تعداد جهت نمایش  : </label>
			<input id="<?php echo $this->get_field_id( 'posts_number' ); ?>" name="<?php echo $this->get_field_name( 'posts_number' ); ?>" value="<?php echo $instance['posts_number']; ?>" size="3" type="text" />
		</p>
		<p>
			<label for="<?php echo $this->get_field_id( 'posts_order' ); ?>">محبوب بر اساس : </label>
			<select id="<?php echo $this->get_field_id( 'posts_order' ); ?>" name="<?php echo $this->get_field_name( 'posts_order' ); ?>" >
				<option value="popular" <?php if( $instance['posts_order'] == 'popular' ) echo "selected=\"selected\""; else echo ""; ?>>بیشترین دیدگاه</option>
			</select>
		</p>
	<?php
	}
}
?>
