<?php

add_action( 'widgets_init', 'wp_posts_listtime_widget' );
function wp_posts_listtime_widget() {
	register_widget( 'wp_posts_listtime' );
}

class wp_posts_listtime extends WP_Widget {

	public function __construct(){
		$widget_ops = array( 'classname' => 'posts-listtime','description' => 'سایدبار چپ');
		$control_ops = array( 'width' => 250, 'height' => 350, 'id_base' => 'posts-listtime-widget' );
		parent::__construct( 'posts-listtime-widget',''.__( 'News - مطالب لیستی با تاریخ' , 'wp'), $widget_ops, $control_ops );
	}
	
	function widget( $args, $instance ) {
		extract( $args );


		$title     = $title = apply_filters( 'widget_title', $instance['title'], $instance, $this->id_base );
		$category  = $instance['category'];
		$number    = $instance['number'];

		echo $before_widget;
		echo $before_title;
		echo $title ; 
		echo '</b></p></div><div class="sidebar-axenan">'; ?>
          <div class="list_post">
          <?php $pic_posts = new WP_Query( array( 

			'post_type'      => 'post',
			'posts_per_page' => $number,
			'cat'            => $category

		) );

		if ( $pic_posts->have_posts() ) {
			while ( $pic_posts->have_posts() ) {
				$pic_posts->the_post(); ?>
<div class="list_post_contin"><li>
<h3><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
<time><span><?php echo wt_time_ago(); ?><em>قبل</em></span></time>
</li></div>
          <?php }
		          } else {

			echo 'مطلبی موجود نیست';

		}
		wp_reset_postdata(); ?>
		
          </ul>

	<?php 
		echo $after_widget;
	}

	function update( $new_instance, $old_instance ) {
		$instance              = $old_instance;
		$instance['title']     = wp_strip_all_tags( $new_instance['title'] );
		$instance['category']  = wp_strip_all_tags( $new_instance['category'] );
		$instance['number']    = is_numeric( $new_instance['number'] ) ? intval( $new_instance['number'] ) : 5;

		return $instance;
	}

	function form( $instance ) {
		$defaults  = array( 'title' => '', 'category' => '', 'number' => 5, 'show_date' => '' );
		$instance  = wp_parse_args( ( array ) $instance, $defaults );
		$title     = $instance['title'];
		$category  = $instance['category'];
		$number    = $instance['number'];
		
		?>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'title' ); ?>"><?php _e( 'عنوان' ); ?>:</label>
			<input type="text" class="widefat" id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo esc_attr( $title ); ?>" />
		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'category' ); ?>"><?php _e( 'انتخاب دسته' ); ?>:</label>				
			
			<?php

			wp_dropdown_categories( array(

				'orderby'    => 'title',
				'hide_empty' => false,
				'name'       => $this->get_field_name( 'category' ),
				'id'         => $this->get_field_id( 'category' ),
				'class'      => 'widefat',
				'selected'   => $category

			) );

			?>

		</p>
		
		<p>
			<label for="<?php echo $this->get_field_id( 'number' ); ?>"><?php _e( 'تعداد مطالب' ); ?>: </label>
			<input type="text" id="<?php echo $this->get_field_id( 'number' ); ?>" name="<?php echo $this->get_field_name( 'number' ); ?>" value="<?php echo esc_attr( $number ); ?>" size="3" />
		</p>

		
		
		<?php
	
	}
}
?>